%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
% Program to categorize the Ref set
%$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
% When two different signals from different sets are given 
% easily we can identify the signal parameters
%

clear all;
close all;

% Time measurement
tic
% goto the reqd dir
current_dir = pwd;
cd  c:/cardiacsignals/;

% first write the filenames with .xls extension to a text file. 
system('dir /b *.xls > temp_list.txt')

% open the file
file_id = fopen('temp_list.txt', 'r');

string_line= fgets(file_id);

data = 0;
i = 1;

while (string_line ~= -1)
        string_line= fgets(file_id);
        
        if (string_line ~= -1)
            fprintf('\nreading from file %s\n', string_line);
               temp= read_xls_file(string_line(1:length(string_line)-1));
              
               % keeping the track of the size
               
               len (i) = length ( temp);
               
               % verify whether the new signal has more data than previous
               % ones
               
               if ( length(data) < length (temp) )
                  for j = length (data) : length (temp)
                      data (j, :) = 0;
                  end
               else
                   % if new signal size is less than data lenght then pad
                   % zeros at the end of new signal
                   
                   if ( length (data) > length ( temp) )
                       
                       for j = length (temp) : length (data)
                           temp (j, 1) = 0;
                       end
                       
                   end
               end
               
               data (:, i) = temp;
               i = i + 1;
        end
end

% Correlation 
data_size = size ( data);

for i =1 : data_size (2)
    for j = 1: data_size (2)
        
%         disp (i)
%         disp (j)
        sig1 = data (1:len (i), i);
        sig1 = sig1 / norm (sig1);
        
        sig2 = data (1:len (j), j);
        sig2 = sig2 / norm (sig2);
        
        temp = xcorr ( sig1, sig2 );

%         % Considering FFT
%         
%         fsig1 = fft (sig1);
%         fsig2 = fft (sig2);
%         
%         temp = xcorr (fsig1, fsig2);
        
        % taking the middle value 
        %corr_mat (i, j) = norm ( temp);
        corr_mat (i, j) = temp ( (length (temp ) +1)/ 2);
    end
end

for i = 1: data_size (2) 
    for j = 1:data_size (2) 
        per_corr (i, j) = corr_mat (i, j) / corr_mat (i, i);
    end
end


% Ploting 

% Equalling data size

% change the values of pos1 and pos2 to see the signal parameters
% variations

pos1 = 1;
sig1 = data (1:len (pos1), pos1);
sig1 = sig1 / norm (sig1);

pos2 = 34;
sig2 = data (1:len (pos1), pos2);
sig2 = sig2 / norm (sig2);

figure
mesh(data);
title('Reference Signal Set');

figure
plot (sig1, 'b'); 
hold on;
plot (sig2, 'r');
hold on;

grid
legend('Reference signal 1', 'Reference Signal 2', 'location', 'Best');
title('Comparison of two refernce signals');
xlabel('sample number');
ylabel('ECG Amplitude')
% close the file.
fclose(file_id);

% get back to the old dir
cd(current_dir)

toc
% End of time calculation
